﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCOUTCOMES")]

public partial class ucOutcomeMeasures : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// on episode treatment select 
    /// </summary>
    public void OnTreeSelect()
    {
        //get the pathway event
        //CCPA cpa = new CCPA();
        //DataSet ds = cpa.GetPatPWEventByIDDS(BaseMstr,
          //                                   BaseMstr.SelectedPatientID,
            //                                 CDataUtils2.ToLong(PatPWEventID));

        //show/hide buttons as needed
        //if (!CDataUtils2.IsEmpty(ds))
        //{
            //long lStatus = CDataUtils2.GetDSLongValue(ds, "STATUS");
            if (BaseMstr.EventStatus == 2)
            {
                btnMeasureReview.Disable();
            }
            else
            {
                btnMeasureReview.Enable();
            }
        //}

        btnMeasureTrend.Enable();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 review an entry from the entry popup
    /// </summary>
    public void OnReviewCommand(string strJsonRecord)
    {
        string strPatPWID = CDataUtils2.GetJsonRecordValue("pat_pw_id", strJsonRecord);
        string strPatPWEventID = CDataUtils2.GetJsonRecordValue("pat_pw_event_id", strJsonRecord);
        string strPWEventModuleID = CDataUtils2.GetJsonRecordValue("pw_event_module_id", strJsonRecord);
        string strStatusID = CDataUtils2.GetJsonRecordValue("current_status_id", strJsonRecord);
        string strSeverityID = CDataUtils2.GetJsonRecordValue("current_severity_id", strJsonRecord);
        string strModule = CDataUtils2.GetJsonRecordValue("module", strJsonRecord);

        //5=review
        long lEventEntryTypeID = 5;

        //show the window for a new record
        ucEventEntry.OnNewEntry(lEventEntryTypeID,
                                BaseMstr.SelectedPatientID,
                                CDataUtils2.ToLong(strPatPWID),
                                CDataUtils2.ToLong(strPatPWEventID),
                                CDataUtils2.ToLong(strPWEventModuleID),
                                CDataUtils2.ToLong(strStatusID),
                                CDataUtils2.ToLong(strSeverityID),
                                strModule);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 reload the tree control, called via MessageBus to updae the tree
    /// </summary>
    /// <returns></returns>
    public bool ReloadTree()
    {
        long lPatPWEventID = CDataUtils2.ToLong(PatPWEventID);
        if (lPatPWEventID > 0)
        {
            btnMeasureReview.Disable();
            btnMeasureTrend.Disable();

            //load the tree
            LoadTree(lPatPWEventID);

            //I had to move the tree inside of another panel
            //then all worked
            tpnlUCOM.Render(tpnlUCOM, RenderMode.Replace);
            
            //clear any selected items and force the user to re-select
            TreeSelectionModel tm = (TreeSelectionModel)tpnlUCOM.GetSelectionModel();
            tm.SelectedIndex = -1;
            tm.SelectedRow = null;
            tm.SelectedRecordID = "-1";
            tm.ClearSelection();
            tm.UpdateSelection();
        }

        return true;
    }

    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 event entry id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCOMPatPWEventID"] != null)
            {
                strValue = Session["UCOMPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCOMPatPWEventID"] = Convert.ToString(value); }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 Initialize the control
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public bool InitializeControl(string strPatPWEventID)
    {
        //don't reload the outcomes if already loaded
        if(strPatPWEventID == PatPWEventID)
        {
            return true;
        }

        return InitializeControl(CDataUtils2.ToLong(strPatPWEventID));
    }

    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 initialize the control
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl(long lPatPWEventID)
    {
        //cache the PW event id
        PatPWEventID = Convert.ToString(lPatPWEventID);

        tpnlUCOM.Enable();
       
        //load the tree
        LoadTree(lPatPWEventID);

        //load the event entry user control
        ucEventEntry.BaseMstr = BaseMstr;
        ucEventEntry.InitializeControl(lPatPWEventID);

        //re-render the tree in place
        Ext.Net.MessageBus.Default.Publish("MBL_RELOADOUTCOMES");


        //disable if this event is closed
        //get the note info for the event selected
        CCPA cpa = new CCPA();
        DataSet dsEvt = cpa.GetPatPWEventByIDDS(BaseMstr,
                                             BaseMstr.SelectedPatientID,
                                            lPatPWEventID);

        long lStatus = CDataUtils2.GetDSLongValue(dsEvt, "STATUS");
        if (lStatus == 2)
        {
            tpnlUCOM.Disable();
        }

        return true;
    }

    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 load the outome measures tree
    /// </summary>
    protected void LoadTree(long lPatPWEventID)
    {
        //disable the review button and graph       
        btnMeasureReview.Disable();
        btnMeasureTrend.Disable();

        //load here fro now...
        CPWEvent evt = new CPWEvent();
        DataSet ds = evt.GetOutcomeMeasureDS(BaseMstr,
                                             lPatPWEventID); 
        
        //clear the root
        if (tpnlUCOM.Root != null)
        {
            if (tpnlUCOM.Root.Count > 0)
            {
                tpnlUCOM.Root.Clear();
            }
        }
        
        //add a new root
        Ext.Net.Node ndRoot;
        ndRoot = new Node() { Text = "" };
        ndRoot.Expanded = true;
        ndRoot.EmptyChildren = true;
        tpnlUCOM.Root.Add(ndRoot);

        if (ds != null)
        {
            foreach (DataTable table in ds.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    //new node under root
                    Ext.Net.Node nd = new Ext.Net.Node();

                    //set the text of the node
                    nd.Text =  HttpUtility.HtmlEncode(CDataUtils2.GetDSStringValue(row, "MODULE"));
                  
                    //is this instrument a GOAL
                    bool bGoal = false;
                    if (CDataUtils2.GetDSLongValue(row, "IS_GOAL") > 0)
                    {
                        bGoal = true;
                    }

                    //set the severity
                    long lSevID = CDataUtils2.GetDSLongValue(row, "current_severity_id");
                    //default unk
                    nd.IconFile = "images/gray15t.png";
                    nd.Qtip = "Gray";
                    if(lSevID == 1) //mild
                    {
                        nd.IconFile = "images/green15t.png";
                        nd.Qtip = "Green";
                    }
                    if(lSevID == 2) //moderate
                    {
                        nd.IconFile = "images/yellow15t.png";
                        nd.Qtip = "Yellow";
                   
                    }
                    if(lSevID == 3) //severe
                    {
                        nd.IconFile = "images/red15t.png";
                        nd.Qtip = "Red";
                   
                    }
                    
                    //set the node id
                    nd.NodeID = CDataUtils2.GetDSStringValue(row, "PW_EVENT_MODULE_ID");

                    //do not expand and dont show empty children
                    nd.Expanded = false;
                    nd.EmptyChildren = false;

                    //default to having children, will reset below as needed
                    nd.Leaf = false;

                    //add items to the tree/grid
                    ConfigItem ciPatientID = new ConfigItem("patient_id", CDataUtils2.GetDSStringValue(row, "patient_id"));
                    nd.CustomAttributes.Add(ciPatientID);

                    ConfigItem ciModuleID = new ConfigItem("mid", CDataUtils2.GetDSStringValue(row, "mid"));
                    nd.CustomAttributes.Add(ciModuleID);

                    ConfigItem ciIntakeID = new ConfigItem("intake_id", CDataUtils2.GetDSStringValue(row, "intake_id"));
                    nd.CustomAttributes.Add(ciIntakeID);

                    ConfigItem ciModule = new ConfigItem("module", HttpUtility.HtmlEncode(CDataUtils2.GetDSStringValue(row, "module")));
                    nd.CustomAttributes.Add(ciModule);

                    ConfigItem ciCurrInterp = new ConfigItem("current_interpretation", CDataUtils2.GetDSStringValue(row, "current_interpretation"));
                    if (bGoal)
                    {
                        ciCurrInterp.Value = "GOAL";
                    }
                    nd.CustomAttributes.Add(ciCurrInterp);

                    ConfigItem ciCurrScore = new ConfigItem("current_score", CDataUtils2.GetDSStringValue(row, "current_score"));
                    nd.CustomAttributes.Add(ciCurrScore);
                    
                    ConfigItem ciPrevScore = new ConfigItem("prev_score", CDataUtils2.GetDSStringValue(row, "prev_score"));
                    nd.CustomAttributes.Add(ciPrevScore);

                    ConfigItem ciCurrStatus = new ConfigItem("current_status", CDataUtils2.GetDSStringValue(row, "current_status"));
                    nd.CustomAttributes.Add(ciCurrStatus);
                   
                    ConfigItem ciReview = new ConfigItem("pw_event_module_id", CDataUtils2.GetDSStringValue(row, "pw_event_module_id"));
                    ciReview.Value = CDataUtils2.GetDSStringValue(row, "pw_event_module_id");
                    nd.CustomAttributes.Add(ciReview);

                    ConfigItem ciPatPWEventID = new ConfigItem("pat_pw_event_id", CDataUtils2.GetDSStringValue(row, "pat_pw_event_id"));
                    nd.CustomAttributes.Add(ciPatPWEventID);

                    ConfigItem ciPatPWID = new ConfigItem("pat_pw_id", CDataUtils2.GetDSStringValue(row, "pat_pw_id"));
                    nd.CustomAttributes.Add(ciPatPWID);

                    ConfigItem ciCurrStatusID = new ConfigItem("current_status_id", CDataUtils2.GetDSStringValue(row, "current_status_id"));
                    nd.CustomAttributes.Add(ciCurrStatusID);

                    ConfigItem ciCurrSeverityID = new ConfigItem("current_severity_id", CDataUtils2.GetDSStringValue(row, "current_severity_id"));
                    nd.CustomAttributes.Add(ciCurrSeverityID);

                    ConfigItem ciCurrSeverity = new ConfigItem("current_severity", CDataUtils2.GetDSStringValue(row, "current_severity"));
                    nd.CustomAttributes.Add(ciCurrSeverity);

                    ConfigItem ciEventStatus = new ConfigItem("event_status", CDataUtils2.GetDSStringValue(row, "event_status"));
                    nd.CustomAttributes.Add(ciEventStatus);
                    
                    //get the intake id
                    long lIntakeID = CDataUtils2.GetDSLongValue(row, "intake_id");
                    long lMID = CDataUtils2.GetDSLongValue(row, "mid");

                    //get sub scores if we have an intake_id
                    if (lIntakeID > 0)
                    {
                        bool bHasChildren = false;
                                   
                        DataSet dsScores = evt.GetIntakeScoreDS(BaseMstr, lIntakeID, lMID);
                        if (dsScores != null)
                        {
                            foreach (DataTable tableScore in dsScores.Tables)
                            {
                                foreach (DataRow rowScore in tableScore.Rows)
                                {
                                    //exclude total score from subs as its already shown above
                                    long lSeries = CDataUtils2.GetDSLongValue(rowScore, "series");
                                    if (lSeries > 0)
                                    {
                                        bHasChildren = true;

                                        Ext.Net.Node ndSub = new Ext.Net.Node();

                                        ndSub.Text = "";
                                        ndSub.Icon = Ext.Net.Icon.BulletBlack;

                                        //not expanded
                                        ndSub.Expanded = false;

                                        //no empty children
                                        ndSub.EmptyChildren = false;

                                        //subscale scores have no sub items so they are a leaf
                                        ndSub.Leaf = true;

                                        //add an item to the module section, in this case its the description of the score
                                        ConfigItem ciModuleSub = new ConfigItem("module", HttpUtility.HtmlEncode(CDataUtils2.GetDSStringValue(rowScore, "description")));
                                        ndSub.CustomAttributes.Add(ciModuleSub);

                                        //sub scale interpretation
                                        ConfigItem cic1 = new ConfigItem("current_interpretation", CDataUtils2.GetDSStringValue(rowScore, "interpretation"));
                                        ndSub.CustomAttributes.Add(cic1);

                                        //sub scale score
                                        ConfigItem cic2 = new ConfigItem("current_score", CDataUtils2.GetDSStringValue(rowScore, "score"));
                                        ndSub.CustomAttributes.Add(cic2);

                                        //no prev score
                                        ConfigItem cic3 = new ConfigItem("prev_score", CDataUtils2.GetDSStringValue(rowScore, "prev_score"));
                                        ndSub.CustomAttributes.Add(cic3);

                                        //no current status for subs
                                        ConfigItem cic4 = new ConfigItem("current_status", "");
                                        ndSub.CustomAttributes.Add(cic4);

                                        ConfigItem cic5 = new ConfigItem("pw_event_module_id", "-1");
                                        ndSub.CustomAttributes.Add(cic5);


                                        ndSub.CustomAttributes.Add(ciPatientID);
                                        ndSub.CustomAttributes.Add(ciModuleID);
                                        ndSub.CustomAttributes.Add(ciIntakeID);
                                        ndSub.CustomAttributes.Add(ciEventStatus);
                                        
                                        //add the sub to the tree
                                        nd.Children.Add(ndSub);
                                    }
                                }
                            }
                        }

                        //if the dataset is empty then we have no chidlren
                        if (CDataUtils2.IsEmpty(dsScores))
                        {
                            nd.Leaf = true;
                        }

                        if (!bHasChildren)
                        {
                            nd.Leaf = true;
                        }

                    }
                    else
                    {
                        //no sub scales to show so this is a leaf and cannot be expanded
                        nd.Leaf = true;
                    }
                                                         
                    //add the outcome and scores to the root node
                    ndRoot.Children.Add(nd);                  
                }
            }
        }
    }


    /// <summary>
    /// US:6831 US:6832 US:6833 US:6834 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        ucTrendGraph.BaseMstr = BaseMstr;
        ucEventEntry.BaseMstr = BaseMstr;
     
        if (!IsPostBack)
        {
            //empty load to keep things organized
            InitializeControl(-1);

            //disable the review button and graph       
            btnMeasureReview.Disable();
            btnMeasureTrend.Disable();
        }
    }
    

}